=pod

License

Copyright © 2018, Numato Systems Private Limited. All rights reserved.

This software including all supplied files, Intellectual Property, know-how
or part of thereof as applicable (collectively called SOFTWARE) in source
and/or binary form with accompanying documentation is licensed to you by
Numato Systems Private Limited (LICENSOR) subject to the following conditions.

1. This license permits perpetual use of the SOFTWARE if all conditions in this
   license are met. This license stands revoked in the event of breach of any
   of the conditions.    
2. You may use, modify, copy the SOFTWARE within your organization. This
   SOFTWARE shall not be transferred to third parties in any form except
   fully compiled binary form as part of your final application.
3. This SOFTWARE is licensed only to be used in connection with/executed on
   supported products manufactured by Numato Systems Private Limited.
   Using/executing this SOFTWARE on/in connection with custom or third party
   hardware without the LICENSOR's prior written permission is expressly
   prohibited.
4. You may not download or otherwise secure a copy of this SOFTWARE for the
   purpose of competing with Numato Systems Private Limited or subsidiaries in
   any way such as but not limited to sharing the SOFTWARE with competitors, 
   reverse engineering etc... You may not do so even if you have no gain 
   financial or otherwise from such action.
5. DISCLAIMER
5.1. USING THIS SOFTWARE IS VOLUNTARY AND OPTIONAL. NO PART OF THIS SOFTWARE
     CONSTITUTE A PRODUCT OR PART OF PRODUCT SOLD BY THE LICENSOR.
5.2. THIS SOFTWARE AND DOCUMENTATION ARE PROVIDED “AS IS” WITH ALL FAULTS,
     DEFECTS AND ERRORS AND WITHOUT WARRANTY OF ANY KIND.
5.3. THE LICENSOR DISCLAIMS ALL WARRANTIES EITHER EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR FITNESS FOR ANY
     PURPOSE.
5.4. IN NO EVENT, SHALL THE LICENSOR, IT’S PARTNERS OR DISTRIBUTORS BE LIABLE OR
     OBLIGATED FOR ANY DAMAGES, EXPENSES, COSTS, LOSS OF MONEY, LOSS OF TANGIBLE
     OR INTANGIBLE ASSETS DIRECT OR INDIRECT UNDER ANY LEGAL ARGUMENT SUCH AS BUT
     NOT LIMITED TO CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH
     OF WARRANTY OR ANY OTHER SIMILAR LEGAL DEFINITION.

This Perl sample script opens the port and sends two commands to the device. These commands 
will turn on Relay0, wait for 2 seconds and then turn off.

Please follow the steps below to test the script.

Prerequisites                                                      
--------------      
install perl                                               
install Win32::SerialPort											
install Time::Hires												
install Switch 

1. Attach the Relay Module to the PC and note the port identifier corresponding to the device
2. Update the line below that starts with "$portName =" with the port number for your device
3. Comment/uncomment lines below as necessary (see associated comments)
4. Run the script by entering the command "perl usbrelay.pl" at command line

=cut

use Win32::SerialPort;

$portName = "COM5";

$serPort = new Win32::SerialPort($portName, quiet) || die "Could not open the port specified";

# Configure the port	   
$serPort->baudrate(9600);
$serPort->parity("none");
$serPort->databits(8);
$serPort->stopbits(1);
$serPort->handshake("none"); #Most important
$serPort->buffers(4096, 4096); 
$serPort->read_interval(100);   
$serPort->read_char_time(5);  
$serPort->read_const_time(100); 
$serPort->write_char_time(5);
$serPort->write_const_time(100);
$serPort->lookclear();

$serPort->purge_all;

###################################################################
                
#                      Get version and id                         #
				
###################################################################	

#Send "ver" command to the device
$serPort->write("ver\r"); 
sleep(1);

#Read response from device
($count,$data) = $serPort->read(25); 

#Parse and print
$substring = substr $data,0,$count - 2;
print "\n$substring";

#Send "id get" command to the device
$serPort->write("id get\r"); #Sending "id get" command to the device
sleep(1);

#Read response from device
($count, $data) = $serPort->read(25); #read data from the device

#Parse and print
$substring = substr $data,0,$count - 2;
print "\n$substring";

######################################################################
                  
#                   Relay commands on/off/read                       #
				   				   
######################################################################

$serPort->purge_all;

#Send "relay on" command to the device
$serPort->write("relay on 0\r");
print "\nrelay on 0";

print "\nWaiting for 2 seconds";
sleep(2);

$serPort->purge_all;

#Send "relay off" command to the device
$serPort->write("relay off 0\r");
print "\nrelay off 0";	
sleep(1);
	
$serPort->purge_all;

#Send "relay read" command to the device
$serPort->write("relay read 0\r");
sleep(1);

#Read response from device
($count, $data) = $serPort->read(25);

#Parse and print
$substring = substr $data,0,$count - 2; 
print "\nValue received $substring"; 