=pod

License

Copyright © 2018, Numato Systems Private Limited. All rights reserved.

This software including all supplied files, Intellectual Property, know-how
or part of thereof as applicable (collectively called SOFTWARE) in source
and/or binary form with accompanying documentation is licensed to you by
Numato Systems Private Limited (LICENSOR) subject to the following conditions.

1. This license permits perpetual use of the SOFTWARE if all conditions in this
   license are met. This license stands revoked in the event of breach of any
   of the conditions.    
2. You may use, modify, copy the SOFTWARE within your organization. This
   SOFTWARE shall not be transferred to third parties in any form except
   fully compiled binary form as part of your final application.
3. This SOFTWARE is licensed only to be used in connection with/executed on
   supported products manufactured by Numato Systems Private Limited.
   Using/executing this SOFTWARE on/in connection with custom or third party
   hardware without the LICENSOR's prior written permission is expressly
   prohibited.
4. You may not download or otherwise secure a copy of this SOFTWARE for the
   purpose of competing with Numato Systems Private Limited or subsidiaries in
   any way such as but not limited to sharing the SOFTWARE with competitors, 
   reverse engineering etc... You may not do so even if you have no gain 
   financial or otherwise from such action.
5. DISCLAIMER
5.1. USING THIS SOFTWARE IS VOLUNTARY AND OPTIONAL. NO PART OF THIS SOFTWARE
     CONSTITUTE A PRODUCT OR PART OF PRODUCT SOLD BY THE LICENSOR.
5.2. THIS SOFTWARE AND DOCUMENTATION ARE PROVIDED “AS IS” WITH ALL FAULTS,
     DEFECTS AND ERRORS AND WITHOUT WARRANTY OF ANY KIND.
5.3. THE LICENSOR DISCLAIMS ALL WARRANTIES EITHER EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR FITNESS FOR ANY
     PURPOSE.
5.4. IN NO EVENT, SHALL THE LICENSOR, IT’S PARTNERS OR DISTRIBUTORS BE LIABLE OR
     OBLIGATED FOR ANY DAMAGES, EXPENSES, COSTS, LOSS OF MONEY, LOSS OF TANGIBLE
     OR INTANGIBLE ASSETS DIRECT OR INDIRECT UNDER ANY LEGAL ARGUMENT SUCH AS BUT
     NOT LIMITED TO CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH
     OF WARRANTY OR ANY OTHER SIMILAR LEGAL DEFINITION.

    Perl code demonstrating features of Numato Lab 64 Channel 
    USB Relay Module.
    
    Usage: scriptname.pl <PORT>
    E.g.: 64usbrelay.pl COM1


Prerequisites                                                      
--------------                                                     
install Win32::SerialPort											
install Time::Hires												
install Switch

=cut

#!/usr/bin/perl -w
use diagnostics;
#use strict;
use warnings;
use Win32::SerialPort;
use Time::HiRes;
use Switch;
my $port;
$num_args = $#ARGV + 1;

if ($num_args != 1) {
print "\nUsage: scriptname.pl <PORT>\nEg: 64usbrelay.pl COM1\n";
exit;
}
else {
$port = $ARGV[0];
}

##########################################################
#               Serial port related methods              #
##########################################################

#Create a new Serialport object and Open Port for communication
my $SerPort = Win32::SerialPort-> new($port) || die "Could not open the port specified";

#Connect to the device
$SerPort->baudrate(19200);
$SerPort->parity("none");
$SerPort->databits(8);
$SerPort->stopbits(1);
$SerPort->handshake("none");
$SerPort->buffers(4096, 4096);
$SerPort->read_interval(100);
$SerPort->read_char_time(5);
$SerPort->read_const_time(100);
$SerPort->write_char_time(5);
$SerPort->write_const_time(100);
$SerPort->lookclear();

$SerPort->purge_all;

##########################################################
#                           Menus                        #
##########################################################

#Display the menu and returns user selection
sub get_menuselection {
    print "\nPlease select from following menu options: ";
    print "\nMenu:\n";
    %menu = ( 1,"Get Firmware Version", 2, "Get Module ID", 3, "Set Module ID", 4, "Relay Status and control", 5, "GPIO Status and control", 6, "ADC Status", 7, "Reset", 'q', "Exit");
    foreach my $key (sort(keys %menu)) {
    print $key, ':',$menu{$key}, "\n";
    }
    print "\nEnter Selection: ";
    return my $selection = lc <STDIN>;
}

#Display the menu and returns user selection
sub relay_status_control {
    print "\nPlease select from following menu options: \n";
    my %menu = ( 1, "Individual Relay Status", 2, "Read all Relays", 3, "Individual Relay Control", 4, "Write all Relays", 'b', "Back to main menu", 'q', "Exit");
    foreach my $key (sort(keys %menu)) {
    print $key, ':',$menu{$key}, "\n";
    }
    print "\nEnter Selection: ";
    return my $selection = lc <STDIN>;
}

#Display the menu and returns user selection
sub relay_control {
    print "\nPlease select from following menu options: \n";
    my %menu = ( 1, "ON Relay", 2, "OFF Relay", 3, "Back to previous menu", 'b', "Back to main menu", 'q', "Exit");
    foreach my $key (sort(keys %menu)) {
    print $key, ':',$menu{$key}, "\n";
    }
    print "\nEnter Selection: ";
    return my $selection = lc <STDIN>;
}	

#Display the menu and returns user selection
sub get_gpio {
    print "\nPlease select from following menu options: \n";
    my %menu = ( 1, "GPIO Status", 2, "GPIO Control", 'b', "Back to main menu", 'q', "Exit" );
    foreach my $key (sort(keys %menu)) {
    print $key, ':',$menu{$key}, "\n";
    }
    print "\nEnter Selection: ";
    return my $selection = lc <STDIN>;
}

#Set/Clear GPIOs
sub gpio_control {
    print "\nPlease select from following menu options: \n";
    my %menu = ( 1, "Set GPIO", 2, "Clear GPIO", 3, "Back to previous menu", 'b', "Back to main menu", 'q', "Exit" );
    foreach my $key (sort(keys %menu)) {
    print $key, ':',$menu{$key}, "\n";
    }
    print "\nEnter Selection: ";
    return my $selection = lc <STDIN>;
}

##########################################################
#             Module related misc. functions             #
##########################################################

#Retrieve and print FW version
sub get_firmware {
    $SerPort->purge_all;
    $SerPort->write("ver\r");
    sleep(1);
    return ($SerPort->read(25)=~ /^.{3}([^>]*)/);
}

#Retrieve and print Module ID
sub get_moduleid {
    $SerPort->purge_all;
    $SerPort->write("id get\r");
    sleep(1);
    return ($SerPort->read(25)=~ /^.{6}([^>]*)/);
}

#Sets new Module ID	
sub set_moduleid {	
    #Get new Module ID form user
    while(1) {
        print "Enter new ID (8 alphanumeric characters only): ";
        my $new_id = <STDIN>;
        chomp $new_id;
        if(length($new_id) == 8) {
            $SerPort->write("id set " . $new_id . "\r");
            $SerPort->purge_all;
    return "\nModule ID Set Successfully\n";
        }
    }
}

#Resets the Module
sub Reset {
    $SerPort->write("reset\r");
    return "\nReset successfully\n";
}
##########################################################
#                     Relay operations                   #
##########################################################

#Retrieve and print Relay status
sub get_relaystatus {
    $SerPort->purge_all;
    #Get Relay index/number from the user
    while(1) {
        print "Please enter Relay number : ";
        my $relay_number = <STDIN>;
        $relay_number = sprintf ("%02d",$relay_number);
        if($relay_number<64) {
            #Send command and Read and process response from the device
            $SerPort->write("relay read " . $relay_number . "\r");
            sleep(1);
            print "\nStatus of Relay #" . $relay_number;
            return ($SerPort->read(25)=~ /^.{13}([^>]*)/);
        }
    }
}

#Relay ON	
sub relay_on {
    #Get Relay index/number from the user
    while(1) {
        print "Please enter Relay number : ";
        my $relay_number = <STDIN>;
        $relay_number = sprintf ("%02d",$relay_number);
        if($relay_number<64) {
            #Send command
            $SerPort->write("relay on " . $relay_number . "\r");
            return;
        }
    }
}

#Relay OFF	
sub relay_off {
    #Get Relay index/number from the user
    while(1) {
        print "Please enter Relay number : ";
        my $relay_number = <STDIN>;
        $relay_number = sprintf ("%02d",$relay_number);
        if($relay_number<64) {
            #Send command
            $SerPort->write("relay off " . $relay_number . "\r");
            return;
        }
    }
}

#Retrieve and print all relay's status	
sub readall {
    $SerPort->purge_all;
    #Send Command 
    
    $command = "relay readall\r";
    $SerPort->write($command);
    sleep(1);
    #Read Relay Status
    return ($SerPort->read(35)=~ /^.{13}([^>]*)/);
}

#write to all relays at a time	
sub writeall {
    #Get new Relay status from user
    while(1) {
        print "Enter Value to write(E.g.:ff01ff0110ffff10) : ";
        my $value = lc <STDIN>;
        chomp $value;
        if(length($value)==16) {
            if($value =~ /^[a-fA-F0-9]+(?:,[a-fA-F0-9]+)*?$/) {
                #Send Command
                $SerPort->write("relay writeall " . $value . "\r");
                return;
            }
        }
    }
}

##########################################################
#                     GPIO operations                    #
##########################################################

#Retrieve and print GPIO status
sub get_gpiostatus {
    $SerPort->purge_all;
    #Get GPIO index/number from the user
    while(1) {
        print "Please enter GPIO number ( 0 to 7): ";
        my $gpio_number = <STDIN>;
        chomp $gpio_number;
        if($gpio_number <8) {
            #Send command and Read and process response from the device
            $SerPort->write("gpio read " . $gpio_number . "\r");
            sleep(1);
            print "\nStatus of GPIO #" . $gpio_number . "\n------------------";
            return ($SerPort->read(25)=~ /^.{11}([^>]*)/);
        }
    }
}

#Set GPIO high
sub gpio_set {
    #Get GPIO index/number from the user
    while(1) {
        print "Please enter GPIO number ( 0 to 7): ";
        my $gpio_number = <STDIN>;
        #Get new state/status from the user
        if($gpio_number <8) {
            $SerPort->write("gpio set " . $gpio_number . "\r");
            return "\nSet Successfully\n";
        }
    }
}

#Set GPIO low
sub gpio_clear {
    #Get GPIO index/number from the user
    while(1) {
        print "Please enter GPIO number ( 0 to 7): ";
        my $gpio_number = <STDIN>;
        #Get new state/status from the user
        if($gpio_number <8) {
            $SerPort->write("gpio clear " . $gpio_number . "\r");
            return "\nSet Successfully\n";
        }
    }
}

##########################################################
#                     ADC/Analog operations              #
##########################################################

#Retrieve and print ADC status
sub get_adcstatus {
    $SerPort->purge_all;
    #Get ADC index/number from the user
    while(1) {
        print "Please enter ADC number ( 0 to 5): ";
        my $adc_number = <STDIN>;
        chomp $adc_number;
        if($adc_number <6) {
            #Send command and Read and process response from the device
            $SerPort->write("adc read " . $adc_number . "\r");
            sleep(1);			
            print "\nStatus of ADC #". $adc_number . "\n----------------"; 
            return ($SerPort->read(25)=~ /^.{10}([^>]*)/);
        }
    }
}

##########################################################
#                   Main Application Code                #
##########################################################

#Connected to device successfully. Display menu and handle user selection.
mainmenu:while(1) {
    #Display menu and retrieve user selection
    $selectedMenuItem = get_menuselection();
    chomp $selectedMenuItem;
    switch ( $selectedMenuItem) {
        case 1 {
            print("\nVersion\n--------", get_firmware());
        }
        case 2 {
            print("\nModule ID\n----------", get_moduleid());
        }
        case 3 {
            print(set_moduleid());
        }
        case 4 {
            relaymenu:while(1) {
                $relay = relay_status_control();
                chomp $relay;
                switch($relay) {
                    #Process the selected option
                    case 1 {
                        #print "Read Relay status";
                        print get_relaystatus();
                    }
                    case 2 {
                        print "\nReadall Status\n---------------",readall();
                    }
                    case 3 {
                        while(1) {
                            $rlycntrl = relay_control();
                            chomp $rlycntrl;
                            switch ($rlycntrl) {
                                case 1 {
                                    relay_on();
                                }
                                case 2 {
                                    relay_off();
                                }
                                case 3 {
                                    goto relaymenu;
                                }
                                case "b" {
                                    goto mainmenu;
                                }
                                case "q" {
                                    print "\nExiting...";
                                    exit;
                                }
                                else {
                                    print "\nUnknown Option Selected! Please enter a valid option from menu below\n";
                                }
                            }
                        }
                    }
                    case 4 {
                        writeall();
                    }
                    case "b" {
                        goto mainmenu;
                    }
                    case "q" {
                        print "\nExiting...";
                        exit;
                    }
                    else {
                        print "\nUnknown Option Selected! Please enter a valid option from menu below\n";
                    }
                }
            }
        }
    
        case 5 {
            gpiomenu:while(1) {
                $gpio = get_gpio();
                chomp $gpio;
                switch($gpio) {
                    case 1 {
                        print get_gpiostatus();
                    }
                    case 2 {
                        while(1) {
                            $gpiocntrl = gpio_control();
                            chomp $gpiocntrl;
                            switch($gpiocntrl) {
                                case 1 {
                                    print gpio_set();
                                }
                                case 2 {
                                    print gpio_clear();
                                }
                                case 3 {
                                    goto gpiomenu;
                                }
                                case "b" {
                                    goto mainmenu;
                                }
                                case "q" {
                                    print "\nExiting...";
                                    exit;
                                }
                                else {
                                    print "\nUnknown Option Selected! Please enter a valid option from menu below\n";
                                }
                            }
                        }
                       }
                    case "b" {
                        goto mainmenu;
                    }
                    case 'q' {
                        print "\nExiting...";
                        exit;
                    }
                    else {
                        print "\nUnknown Option Selected! Please enter a valid option from menu below\n";
                    }
                }			
            }
        }
        
        case 6 {
            print get_adcstatus(); 	
        }
        case 7 {
            print Reset();
        }
        case "q" {
            print "\nExiting...";
            exit;
        }
        else {
            print "\nUnknown Option Selected! Please enter a valid option from menu below\n";
        }
    }
}

#Finally close the Serial Port before exiting
$SerPort->close;